#include "stm32f10x.h"

#define All 0
#define D0	1
#define D1	2
#define D2	3
#define D3	4
#define D4	5
#define D5	6
#define D6	7
#define D7	8

#define Pin_D0	GPIO_Pin_3
#define Pin_D1	GPIO_Pin_2
#define Pin_D2	GPIO_Pin_10
#define Pin_D3	GPIO_Pin_3
#define Pin_D4	GPIO_Pin_5
#define Pin_D5	GPIO_Pin_4
#define Pin_D6	GPIO_Pin_10
#define Pin_D7	GPIO_Pin_8

void DigitalWrite(uint32_t pin, uint8_t state);

int main(void)
{
	GPIO_InitTypeDef GPIO_Struct;

	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA | RCC_APB2Periph_GPIOB | RCC_APB2Periph_AFIO, ENABLE);
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE);

	GPIO_Struct.GPIO_Pin = Pin_D0 | Pin_D1 | Pin_D2 | Pin_D7;
	GPIO_Struct.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_Struct.GPIO_Speed = GPIO_Speed_2MHz;
	GPIO_Init(GPIOA, &GPIO_Struct);

	GPIO_Struct.GPIO_Pin = Pin_D3 | Pin_D4 | Pin_D5 | Pin_D6;
	GPIO_Init(GPIOB, &GPIO_Struct);

	uint32_t count;
	uint8_t pos;

    while(1)
    {
    	for(pos = 3; pos <= 7; pos++) {
    		DigitalWrite(All, 0);
			DigitalWrite(pos, 1);
			for(count = 0; count < 1000000; count++);
    	}
    }
}

void DigitalWrite(uint32_t pin, uint8_t state) {
	if(state == 0) {
		switch(pin) {
		case D0: GPIO_ResetBits(GPIOA, Pin_D0); break;
		case D1: GPIO_ResetBits(GPIOA, Pin_D1); break;
		case D2: GPIO_ResetBits(GPIOA, Pin_D2); break;
		case D3: GPIO_ResetBits(GPIOB, Pin_D3); break;
		case D4: GPIO_ResetBits(GPIOB, Pin_D4); break;
		case D5: GPIO_ResetBits(GPIOB, Pin_D5); break;
		case D6: GPIO_ResetBits(GPIOB, Pin_D6); break;
		case D7: GPIO_ResetBits(GPIOA, Pin_D7); break;
		case All: 	GPIO_ResetBits(GPIOA, Pin_D0 | Pin_D1 | Pin_D2 | Pin_D7);
					GPIO_ResetBits(GPIOB, Pin_D3 | Pin_D4 | Pin_D5 | Pin_D6);
					break;
		default: break;
		}
	} else {
		switch(pin) {
		case D0: GPIO_SetBits(GPIOA, Pin_D0); break;
		case D1: GPIO_SetBits(GPIOA, Pin_D1); break;
		case D2: GPIO_SetBits(GPIOA, Pin_D2); break;
		case D3: GPIO_SetBits(GPIOB, Pin_D3); break;
		case D4: GPIO_SetBits(GPIOB, Pin_D4); break;
		case D5: GPIO_SetBits(GPIOB, Pin_D5); break;
		case D6: GPIO_SetBits(GPIOB, Pin_D6); break;
		case D7: GPIO_SetBits(GPIOA, Pin_D7); break;
		case All: 	GPIO_SetBits(GPIOA, Pin_D0 | Pin_D1 | Pin_D2 | Pin_D7);
					GPIO_SetBits(GPIOB, Pin_D3 | Pin_D4 | Pin_D5 | Pin_D6);
					break;
		default: break;
		}
	}
}
