/**
 * uart.c Using one ADC Channel (A0)on the
 * STM32F103RB Nucleo Board
 *
 * @Author: Nicolas Dammin, 2016
 *
 */

#include "stm32f10x.h"
#include "uart.h"

uint8_t clocksource;
RCC_ClocksTypeDef clocks;

void InitMessage(void);

int main(void)
{
	RCC_GetClocksFreq(&clocks);
	clocksource = RCC_GetSYSCLKSource();
	GPIO_InitTypeDef GPIO_Struct;
	ADC_InitTypeDef ADC_Struct;

	usart_init(9600);

	InitMessage();

	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA | RCC_APB2Periph_AFIO | RCC_APB2Periph_ADC1, ENABLE);


	GPIO_Struct.GPIO_Pin = GPIO_Pin_0;
	GPIO_Struct.GPIO_Mode = GPIO_Mode_AIN;
	GPIO_Init(GPIOA, &GPIO_Struct);

	ADC_Struct.ADC_Mode = ADC_Mode_Independent;
	ADC_Struct.ADC_DataAlign = ADC_DataAlign_Right;
	ADC_Struct.ADC_NbrOfChannel = 1;
	ADC_Struct.ADC_ScanConvMode = ENABLE;
	ADC_Struct.ADC_ContinuousConvMode = ENABLE;
	ADC_Struct.ADC_ExternalTrigConv = ADC_ExternalTrigConv_None;
	ADC_Init(ADC1, &ADC_Struct);

	ADC_RegularChannelConfig(ADC1, 0, 1, ADC_SampleTime_239Cycles5);
	ADC_Cmd(ADC1, ENABLE);

	ADC_SoftwareStartConvCmd(ADC1, ENABLE);

	uint16_t messwert;
	uint32_t count;

    while(1)
    {
    	if(ADC_GetFlagStatus(ADC1, ADC_FLAG_EOC))
    		messwert = 0.6 * messwert + 0.4 * ADC_GetConversionValue(ADC1);
    	usart_sendNumber(messwert>>4);
    	usart_sendChar('\n');
    	for(count = 0; count < 500000; count++);
    }
}

void InitMessage(void) {
	usart_sendText("ADC Example Application.\nClock: ");
	usart_sendNumber(clocks.SYSCLK_Frequency);
	usart_sendText(" Hz\n Clock Source: ");
	switch(clocksource) {
	case 0x00: usart_sendText("HSI"); break;
	case 0x04: usart_sendText("HSE"); break;
	case 0x08: usart_sendText("PLL"); break;
	}
	usart_sendText("\n\n");
}
