/**
 * GPIO "Arduino-Style" GPIO library for STM32
 *
 * @Author: Nicolas Dammin, 2016
 */
#include "stm32f10x.h"
#include "GPIO.h"

uint16_t stm_pin[16] = {GPIO_Pin_3, GPIO_Pin_2, GPIO_Pin_10, GPIO_Pin_3,
                        GPIO_Pin_5, GPIO_Pin_4, GPIO_Pin_10, GPIO_Pin_8,
                        GPIO_Pin_9, GPIO_Pin_7, GPIO_Pin_6, GPIO_Pin_7,
                        GPIO_Pin_6, GPIO_Pin_5, GPIO_Pin_9, GPIO_Pin_8};

void pinMode(uint32_t pin, uint8_t direction) {
	GPIO_InitTypeDef GPIO_Struct;
	GPIO_TypeDef *port;
	uint32_t periph;

	//Disable JTAG Pins and make them GPIO pins
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO, ENABLE);
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE);

	if(pin == D0 || pin == D1 || pin == D2 || pin == D7
			|| pin == D8 || pin == D11 || pin == D12 || pin == D13) {
		port = GPIOA;
		periph = RCC_APB2Periph_GPIOA;
	} else if(pin == D3 || pin == D4 || pin == D5 || pin == D6
			|| pin == D10 || pin == D14 || pin == D15) {
		port = GPIOB;
		periph = RCC_APB2Periph_GPIOB;
	} else if (pin == D9) {
		port = GPIOC;
		periph = RCC_APB2Periph_GPIOC;
	}
	RCC_APB2PeriphClockCmd(periph, ENABLE);
	GPIO_Struct.GPIO_Pin = stm_pin[pin-1];

	switch(direction) {
	case OUTPUT: GPIO_Struct.GPIO_Mode = GPIO_Mode_Out_PP;
				 GPIO_Struct.GPIO_Speed = GPIO_Speed_2MHz;
				 break;
	case INPUT_FLOATING: 	GPIO_Struct.GPIO_Mode = GPIO_Mode_IN_FLOATING;
							break;
	case INPUT_PU:		GPIO_Struct.GPIO_Mode = GPIO_Mode_IPU;
						break;
	case INPUT_PD:		GPIO_Struct.GPIO_Mode = GPIO_Mode_IPD;
						break;
	}
	GPIO_Init(port, &GPIO_Struct);
}

void digitalWrite(uint32_t pin, uint8_t state) {
	if(state == 0) {
		switch(pin) {
		case D0: GPIO_ResetBits(GPIOA, Pin_D0); break;
		case D1: GPIO_ResetBits(GPIOA, Pin_D1); break;
		case D2: GPIO_ResetBits(GPIOA, Pin_D2); break;
		case D3: GPIO_ResetBits(GPIOB, Pin_D3); break;
		case D4: GPIO_ResetBits(GPIOB, Pin_D4); break;
		case D5: GPIO_ResetBits(GPIOB, Pin_D5); break;
		case D6: GPIO_ResetBits(GPIOB, Pin_D6); break;
		case D7: GPIO_ResetBits(GPIOA, Pin_D7); break;
		case D8: GPIO_ResetBits(GPIOA, Pin_D8); break;
		case D9: GPIO_ResetBits(GPIOC, Pin_D9); break;
		case D10: GPIO_ResetBits(GPIOB, Pin_D10); break;
		case D11: GPIO_ResetBits(GPIOA, Pin_D11); break;
		case D12: GPIO_ResetBits(GPIOA, Pin_D12); break;
		case D13: GPIO_ResetBits(GPIOA, Pin_D13); break;
		case D14: GPIO_ResetBits(GPIOB, Pin_D14); break;
		case D15: GPIO_ResetBits(GPIOB, Pin_D15); break;
		default: break;
		}
	} else {
		switch(pin) {
		case D0: GPIO_SetBits(GPIOA, Pin_D0); break;
		case D1: GPIO_SetBits(GPIOA, Pin_D1); break;
		case D2: GPIO_SetBits(GPIOA, Pin_D2); break;
		case D3: GPIO_SetBits(GPIOB, Pin_D3); break;
		case D4: GPIO_SetBits(GPIOB, Pin_D4); break;
		case D5: GPIO_SetBits(GPIOB, Pin_D5); break;
		case D6: GPIO_SetBits(GPIOB, Pin_D6); break;
		case D7: GPIO_SetBits(GPIOA, Pin_D7); break;
		case D8: GPIO_SetBits(GPIOA, Pin_D8); break;
		case D9: GPIO_SetBits(GPIOC, Pin_D9); break;
		case D10: GPIO_SetBits(GPIOB, Pin_D10); break;
		case D11: GPIO_SetBits(GPIOA, Pin_D11); break;
		case D12: GPIO_SetBits(GPIOA, Pin_D12); break;
		case D13: GPIO_SetBits(GPIOA, Pin_D13); break;
		case D14: GPIO_SetBits(GPIOB, Pin_D14); break;
		case D15: GPIO_SetBits(GPIOB, Pin_D15); break;
		}
	}
}

uint8_t digitalRead(uint32_t pin) {
	uint8_t returnVal;

	switch(pin) {
	case D0: returnVal = GPIO_ReadInputDataBit(GPIOA, Pin_D0); break;
	case D1: returnVal = GPIO_ReadInputDataBit(GPIOA, Pin_D1); break;
	case D2: returnVal = GPIO_ReadInputDataBit(GPIOA, Pin_D2); break;
	case D3: returnVal = GPIO_ReadInputDataBit(GPIOB, Pin_D3); break;
	case D4: returnVal = GPIO_ReadInputDataBit(GPIOB, Pin_D4); break;
	case D5: returnVal = GPIO_ReadInputDataBit(GPIOB, Pin_D5); break;
	case D6: returnVal = GPIO_ReadInputDataBit(GPIOB, Pin_D6); break;
	case D7: returnVal = GPIO_ReadInputDataBit(GPIOA, Pin_D7); break;
	case D8: returnVal = GPIO_ReadInputDataBit(GPIOA, Pin_D8); break;
	case D9: returnVal = GPIO_ReadInputDataBit(GPIOC, Pin_D9); break;
	case D10: returnVal = GPIO_ReadInputDataBit(GPIOB, Pin_D10); break;
	case D11: returnVal = GPIO_ReadInputDataBit(GPIOA, Pin_D11); break;
	case D12: returnVal = GPIO_ReadInputDataBit(GPIOA, Pin_D12); break;
	case D13: returnVal = GPIO_ReadInputDataBit(GPIOA, Pin_D13); break;
	case D14: returnVal = GPIO_ReadInputDataBit(GPIOB, Pin_D14); break;
	case D15: returnVal = GPIO_ReadInputDataBit(GPIOB, Pin_D15); break;
	default: break;
	}

	return returnVal;
}
