/**
* Simple library for DisplayTech 64128K graphic LC Display
* Author: Nicolas Dammin, 2016
*/

#include "stm32f1xx_hal.h"
#include "12864KLib.h"

void sendCmd(uint8_t command)
{
	//Enable LCD
	HAL_GPIO_WritePin(LCD_CS_GPIO_Port, LCD_CS_Pin, GPIO_PIN_RESET);

	//A0 Low: Command
	HAL_GPIO_WritePin(LCD_A0_GPIO_Port, LCD_A0_Pin, GPIO_PIN_RESET);

	HAL_SPI_Transmit_IT(&hspi1, &command, 1);

	//Disable LCD
	HAL_GPIO_WritePin(LCD_CS_GPIO_Port, LCD_CS_Pin, GPIO_PIN_SET);
}

void sendData(uint8_t data)
{

	//Enable LCD
	HAL_GPIO_WritePin(LCD_CS_GPIO_Port, LCD_CS_Pin, GPIO_PIN_RESET);

	//A0 Low: Command
	HAL_GPIO_WritePin(LCD_A0_GPIO_Port, LCD_A0_Pin, GPIO_PIN_SET);

	HAL_SPI_Transmit_IT(&hspi1, &data, 1);

	//Disable LCD
	HAL_GPIO_WritePin(LCD_CS_GPIO_Port, LCD_CS_Pin, GPIO_PIN_SET);

}

void initLCD(void)
{
	HAL_GPIO_WritePin(LCD_A0_GPIO_Port, LCD_A0_Pin, GPIO_PIN_RESET);
	HAL_GPIO_WritePin(LCD_CS_GPIO_Port, LCD_CS_Pin, GPIO_PIN_SET);
	HAL_GPIO_WritePin(LCD_RES_GPIO_Port, LCD_RES_Pin, GPIO_PIN_SET);

	HAL_Delay(20);
	HAL_GPIO_WritePin(LCD_RES_GPIO_Port, LCD_RES_Pin, GPIO_PIN_RESET);
	//Init Routine
	HAL_Delay(50);
	HAL_GPIO_WritePin(LCD_RES_GPIO_Port, LCD_RES_Pin, GPIO_PIN_SET);
	HAL_Delay(1);

	sendCmd(LCD_BIAS); // Bias 1/9
	sendCmd(ADC_SEL_REV); //ADC Select -> SEG0 to 131
	sendCmd(COM_OUT_NORM); //SHL Select -> COM63 to COM0

	sendCmd(V0_RESIST_NORM); //V0 Voltage
	sendCmd(EL_VOL_MODE); //Electronic Volume Control
	sendCmd(0xE0); //EVC Register

	sendCmd(BOOSTER_RAT_SET); //Booster Ratio
	sendCmd(BOOSTER_VAL); // x4
	sendCmd(POWER_CONTROL);

	HAL_Delay(20);

	sendCmd(DISP_NORMAL);
	sendCmd(DISP_ON); //Enable Display
	sendCmd(ALL_POINTS_ON); //All Points on
	HAL_Delay(500);
	sendCmd(ALL_POINTS_OFF); //All Points Off

	LCD_Clear();
	LCD_Test();
}

void LCD_Clear(void) {
  uint8_t p, c;

  for(p = 0; p < 8; p++) {
    sendCmd(SET_PAGE | p);
    for(c = 0; c < 132; c++) {
      sendCmd(COL_ADDR_LOW  | (c & 0x0f));
      sendCmd(COL_ADDR_HIGH | ((c >> 4) & 0x0f));
      sendData(0x00);
    }
  }
}

void LCD_Test(void)
{
	for(uint8_t p = 0; p < 8; p=p+2) {
		sendCmd(SET_PAGE | p);
		for(uint8_t c = 0; c < 132; c++) {
			sendCmd(COL_ADDR_LOW  | (c & 0x0f));
			sendCmd(COL_ADDR_HIGH | ((c >> 4) & 0x0f));
			sendData(0xff);
		}
	}
}


