#include <stdio.h>
#include <stdlib.h>

struct Person {
    char name[50], vname[50];
    int id;
    int buch_id;
    int alter;
    struct Person *next;
};

typedef struct Person *Pers;

Pers liste = NULL;
char input;

void add(Pers list);
void list(Pers list);
Pers del(Pers list);

int user_id = 0;

int main()
{
    while(input != 'q') {
        printf("Geben Sie einen Befehl ein: \n\n");
        printf("q - Beenden\nl - Liste der Personen\na - Neue Person hinzufuegen\nd - Person loeschen\n\n");
        scanf("%c", &input);

        if(input == '\n')
            scanf("%c", &input);

        //printf("Wert: %c", input);

        switch(input) {
        //Beenden
        case 'q': break;
        //hinzufuegen
        case 'a': add(liste); break;
        //Anzeigen
        case 'l': list(liste); break;
        //Loeschen
        case 'd': liste = del(liste); break;
        default: printf("Ungueltiger Befehl! Bitte nochmal eingeben\n\n"); break;
        }
    }
}

void add(Pers list) {
    Pers new_pers;

    printf("Neue Person hinzufuegen\n");
    new_pers = (Pers) malloc(sizeof(struct Person));
    new_pers->id = user_id++;
    printf("Name: ");
    scanf("%s", new_pers->name);
    printf("Vorname: ");
    scanf("%s", new_pers->vname);
    printf("Alter: ");
    scanf("%d", &new_pers->alter);
    printf("Buch ID: ");
    scanf("%d", &new_pers->buch_id);
    new_pers->next = NULL;
    if(liste == NULL) {
        liste = new_pers;
    } else {
        new_pers->next = liste;
        liste = new_pers;
    }
}

void list(Pers list) {
    Pers current;

    if(list == NULL) {
        printf("Keine Eintraege!\n\n");
    } else {
        current = list;
        while(current != NULL) {
            printf("ID: %d\nName: %s %s\nAlter: %d\nBuch ID: %d\n-----------------------------------\n\n",
                            current->id, current->vname, current->name, current->alter, current->buch_id);
            current = current->next;
        }
    }
}

Pers del(Pers list) {
    int del_id;
    Pers del_pers;

    printf("Geben Sie die zu loeschende ID ein ");
    scanf("%d", &del_id);

    if(list->id == del_id) {
        del_pers = list;
        list = list->next;
        free(del_pers);
    } else {
        while(list->next != NULL) {
            if(list->next->id == del_id) {
                del_pers = list->next;
                list->next = list->next->next;
                free(del_pers);
                break;
            } else {
                list = list->next;
            }
        }
    }
    return list;
}
